import sys
from Bio import SeqIO

n = int(sys.argv[1])

skipped = 0

filename = "skipped.fa"
print("Writing", filename)
output = open(filename, 'w')

def generate(records, count):
    global skipped
    for i in range(count):
        record = next(records)
        if "N" in record.seq.lstrip("N").rstrip("N"):
            # Skip sequences with internal N's, as BWA may choke on them.
            output.write(record.format('fasta'))
            skipped += 1
            continue
        yield record

filename = "seqlist.fa"
total = 0
print("Reading", filename)
records = SeqIO.parse(filename, 'fasta')
for record in records:
    total += 1
count = total // n
remainder = total - count * n
print("Reading", filename)
records = SeqIO.parse(filename, 'fasta')
for i in range(n):
    if i < remainder:
        current_records = generate(records, count+1)
    else:
        current_records = generate(records, count)
    filename = "seqlist_%d.fa" % i
    print("Writing", filename)
    SeqIO.write(current_records, filename, "fasta")
print("Total: %d" % total)
print("Skipped: %d" % skipped)
output.close()
print("Done")
